



/**********************************************************************************************
 *                                                                                            *
 * Ex2.      :   Using Command Read Hex Distance (RH and Rh)                                  *
 *               By Not Use Interupt Recive Hex Distance                                      *
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                              *
 * Editor         : uvision3 3.62c                                                            *       
 * Compiler       : Keil C51 (V9.51)                                                          *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 15/October/2014                                                           *
 *															                                  *
 * Port Interface :      															    	  *
 *                                                                                            *
 *                : # MCU-89C51RE2 #                 # Module ET-REMOTE Distance #            *
 *                  --------------                  --------------------                      *
 * UART0(RS232#1) :    P3.0(RX0)        Connect             Tx(RS232 PORT)                    *
 *                     P3.1(TX0)        Connect             Rx(RS232 PORT)                    *
 *                     GND              Connect             GND                               *
																							  *
 *                                                         Set JP-TTL/RS232 to RS232          *
 *       Baud Rate = 57600 at Clock 18.432 Mhz             Set JP-BR (57600)                  *
 *                                                         Disable Filter                     *
 *                                                                                            *
 * Port LED       : P1.0..P1.7(Out)  Connect   LED Common Anode for Show Value Hex Cmm RH     *
 *                  P0.0..P0.7(Out)  Connect   LED Common Anode for result of Cmm Rh          *
 *                                                                                            *
 *                                         5V                                 5V              *
 *                                        -+-                                -+-              *
 *                              \\         |                      \\          |               * 
 *                   P1.0--------|<|-------+         P0.0---------|<|---------+               *  
 *                         .               |                  .               |               *
 *                         .               |                  .               |               *
 *                         .               |                  .               |               *                                                                                           
 *                         .    \\         |                  .   \\          |               *
 *                   P1.7-------|<|--------+        P0.7----------|<|---------+               *
 *                                                                                            * 
 *                                                                                            * 
 *   Operation    : Read Distance (RH-Cmm) Value Integer Out to LED Port P1 ,                 *
 *                  Read Distance (Rh-Cmm) Value Integer+Point if Distance                    *
 *                  5.0-5.4 cm  LED Port P0.0-P0.3 ON ,if Distance 5.5-5.9 LED                *
 *                  Port P0.4-P0.7 ON, Distance Other LED PORTC OFF                           *                                                                     
 *                                                                                            *
 **********************************************************************************************/
 

 						
#include <at89c51xd2.h>
#include <stdio.h>

 
  
 unsigned int cnt =0                  ;  //valiable delay Counter timer0
 unsigned char distance[10]           ;


//-----------Initial Funtion -------------

void UART0_Init(void)                 ;
void Timer0_Init(void)                ;

//---------- Function Read Distance ---------

void Echo_Distance(char nm)           ;


//---------- Delay -------------
void delay_ms(unsigned int count)     ;

/********************************************
 **             Function Delay(ms)         **
 ********************************************/

//--------- delay ms ----------
void delay_ms(unsigned int count)          
 {
   	
    TR0 = 1        ;   //On Timer0
    ET0 = 1        ;   //Enable INT. Timer0
    cnt = 0        ;   //Start counter delay 	  

    while(cnt<count){;}

    TR0 = 0        ;	//off Timer0
    ET0 = 0        ;	//Disable INT. Timer0
 }


/***************************************************************
 **                                                           **
 **      Interrupt Service Timer0 (Interrupt every 1 ms)      **
 **                                                           **
 ***************************************************************/

//------- Interrupt Service Timer0 every 1 ms ------

 void TM0_Mod1() interrupt 1 
 {
 
  TF0  = 0         ; //Clear int. flag 
  TH0  = 0xF4      ; //Up date 16bit Reload Timer0
  TL0  = 0x00      ; //0xF400 = 1 ms 

  cnt = cnt+1      ; //Counter for Cursor blink

 }


//-------------- Recive Echo Distance ----------------
//
//        nm : Number Data at Recive                 
//----------------------------------------------------

void Echo_Distance(char nm)
 {
 
   unsigned char m,ch ;  
   
     do
      {
        while(RI==0){;}                   //Check Flag Rx if RI =1 Have data
        ch = SBUF 				        ; //Read data Start Byte
    	RI = 0                          ; //Clear Flag Rx

      }while(ch != '#')                 ; //Check Byte Start of Echo cmm('#')
     
      distance[0] = ch                  ; //keep byte start'#'
      nm--                              ; //Decrease counter Recive Data  
	  for(m=1;m<=nm;m++)                           //Loop keep Recive data all 
       {
		 while(RI==0){;}                ; //Check Flag Rx if RI =1 Have data
         distance[m] = SBUF             ; //Keep data to buffer distance[] 
		 RI = 0                         ; //Clear Flag Rx
       }
   
 }

/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/


void main (void) 
  {
     unsigned char enter = 0x0D ;
	 float ds ;
       
     CKCON0 = 0x01            ;  // div 6 clk mode  X2=1
     AUXR   = 0x10            ;  //Set XRAM = 1792 Byte

	 Timer0_Init()            ;   
	 UART0_Init()             ;

     delay_ms(500)            ;  //Wait Module ET-Remote Distance Ready when Power On
    

//----------------- Start Sent Command Read Distance --------------

    while(1) 
    {    
	     
      //################---- Sent Command RH ----#################

	  //---For CMM RH Recive Data to Buffer Distance[] by Byte0 keep '#' ,Byte1 Keep Hex Distance or 0xFE(Error), 
	  //                                                  Byte2 Keep  0x0D(Enter)
	  
	  TI = 1                           ;   //Set Flag TI=1 for Start sent data
      printf("*RH=%c",enter)           ;   // Sent Command Read Distance Hex Integer      
	  while(TI == 0){;}	                   //Check Flag TI=1 Sent data Ready Exit loop 
      TI = 0                           ;   //Clear Flag TI
	   
      Echo_Distance(3)                 ;  //Wait Recive data  3 Byte
	   
      if((distance[0]=='#')&&(distance[2]==0x0D))  //Check '#' Start Byte and 0x0D for end Byte
	   {  	
	     if(distance[1]== 0xFE)                    //Check data byte1 if is 0xFE(error)  :Distance is not between 3-210 cm
          {            
            P1 = 0xFF                          ;   //LED P1 OFF
	      }
         else    //Distance is between 3-210 cm.
	      {           
			P1 = ~distance[1]                  ;  //Value Hex Distanc Display on LED P1        
		  }          


         distance[0]=0;         //Clear Buffer keep Distance Byte Start and Byte end
         distance[2]=0;

      }
	
	
     //################---- Sent Command Rh ----#################

	  //---For CMM Rh Recive Data to Buffer Distance[] by Byte0 keep '#' , Byte1 Keep Hex Distance Integer or 0xFE(Error), 
	  //                                                  Byte2 keep Hex Distance point  , Byte3 Keep  0x0D(Enter)
	  
      TI = 1                           ;   //Set Flag TI=1 for Start sent data
      printf("*Rh=%c",enter)           ;   // Sent Command Read Distance Hex Integer+Point      
	  while(TI == 0){;}	                   //Check Flag TI=1 Sent data Ready Exit loop 
      TI = 0                           ;   //Clear Flag TI  
	   
      Echo_Distance(4)                            ;  //Wait Recive data  4 Byte
	   
      if((distance[0]=='#')&&(distance[3]==0x0D))    //Check '#' Start Byte and 0x0D for end Byte
	   {  	
	     if(distance[1]== 0xFE)                      //Check data byte1 if is 0xFE(error)  :Distance is not between 3-210 cm
          {          
            P0 = 0xFF                              ; //LED P2 OFF
	      }
         else    //Distance is between 3-210 cm.
	      {         
            ds = distance[1]+(float)distance[2]/10 ; //Total data integer+point keep in valiable float for use Calculate 

		    if((ds>=5.0)&&(ds<= 5.4))                //Check if Distance is 5.0-5.4 cm give LED P0.0-P0.3 ON
			{
              P0 = 0xF0                            ; //LED P0.0..P0.3 =ON
			}
            if((ds>=5.5)&&(ds<= 5.9))                //Check if Distance is 5.5-5.9 cm. give LED P0.4-P0.7 ON
		    { 
              P0 = 0x0F                            ; //LED P0.4..P0.7 =ON
			}
		   if((ds<5.0)||(ds > 5.9))                  //Check if Distance less 5.0 cm. or more 5.9 cm. give LED P0.0-P0.7 OFF
		    {
              P0 = 0xFF                            ; //LED P0.0..P0.7 =OFF

			} 
		  } //else          

         distance[0]=0;         //Clear Buffer keep Distance Byte Start and Byte end
         distance[2]=0;

       } //if
	}//while		  
  }



 /**********************************************************
  **                                                      **  
  **                       Sub-Program                    ** 
  **                                                      **
  **********************************************************/

 /********************************************
  *              Initial UART0               *
  ********************************************/

 void UART0_Init(void)
  {
   	//---------initial Uart0 ------------

   BDRCON |= 0x1C  ;  // Select Internal Baud-Rate,enable,0x1E=Fast //0x1C=No fast 	 
   SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
   ES      = 0     ;  //Disable Serial Uart  Interrupt    

   BRL     = 0xEC  ;  // Baud Rate 57600  ,9600 = 0x88
   PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   BDRCON |= 0x02  ;  // Set SPD  =1 :Fast BR   
 
   EA      = 1     ;  //Enable global Interrupt  
   
  
  }


 /********************************************
  *              Initial Timer0               *
  ********************************************/
 
 void Timer0_Init(void)
 {		
  //------- Initial Timer0 Control Cursor ---------

  TH0	= 0xF4   ;	//Start Interrupt every 1 ms
  TL0   = 0x00   ;
  	 
  TMOD |= 0x01   ; //Use Timer0 Mode1 16-bit																							    
   ET0  = 0	     ; //Disable Timer0 Interrupt 
   TR0  = 0      ; //Set TCON Reg. Off Timer0
 }						   


